<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>DIGITAL ACCOUNTS MANAGEMENT</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="author" content="KASHIF ALI">
    
    <!-- Bootstrap -->
    <link rel="stylesheet" href="css/bootstrap-cerulean.min.css">
    <link rel="stylesheet" href="css/charisma-app.css">
    
    <!-- Custom Styles -->
    <link rel="stylesheet" href="css/bootsrap_my.css">
    <link rel="stylesheet" href="css/jquery-ui.css">
    <link rel="stylesheet" href="css/font-awesome.min2.css">
    
    <style>
        /* ===== Body & Page Theme ===== */
        body {
            background:#f4f6f9;
            font-family: "Segoe UI", Tahoma, sans-serif;
            margin-top: 20px;
        }

        .report-card{
            background:#ffffff;
            padding:25px;
            border-radius:10px;
            box-shadow:0 6px 18px rgba(0,0,0,0.08);
        }

        #lablrpt{
            text-align:center;
            font-weight:700;
            letter-spacing:1px;
            color:#2c3e50;
            margin-bottom:25px;
        }

        /* Buttons */
        #printbtn{
            background:linear-gradient(45deg,#3498db,#2980b9);
            border:none;
            color:#fff;
            margin-right:10px;
        }
        #printbtn:hover{
            background:linear-gradient(45deg,#2980b9,#1f6391);
        }

        #closebtn{
            background:#e74c3c;
            border:none;
            color:#fff;
        }
        #closebtn:hover{
            background:#c0392b;
        }

        /* Table Styling */
        table.report-table{
            width:100%;
            border-collapse:collapse;
            margin-top:15px;
        }
        table.report-table th, table.report-table td{
            border:1px solid #dcdcdc;
            padding:10px;
            text-align:right;
            font-size:13px;
        }
        table.report-table th{
            background:#3498db;
            color:#fff;
            text-align:center;
        }
        table.report-table tr:hover{
            background:#f1f8ff;
        }

        /* Item Summary Row */
        .item-summary td{
            font-weight:700;
            background:#ecf0f1;
            text-align:right;
        }
        .item-summary td:first-child{
            text-align:left;
            font-size:15px;
        }

     @media print {
    /* Hide buttons */
    #printbtn, #closebtn { display:none; }

    /* Force body background */
    body, .report-card { background:white !important; }

    /* Table colors for print */
    table.report-table th {
        background:#3498db !important;
        -webkit-print-color-adjust: exact; 
        color:white !important;
    }

    table.report-table tr.item-summary td {
        background:#ecf0f1 !important;
        -webkit-print-color-adjust: exact;
    }

    table.report-table tr:hover {
        background:transparent !important;
    }
}

    </style>
    
    
    
    <script src="js/jquery-1.12.4.js"></script>
    <script src="js/jquery-ui.js"></script>
</head>
<body>
<div class="container report-card">

    <?php 
        require 'connection.php';
        $accid= $_GET['catid'];
        $from= $_GET['from'];
        $to= $_GET['to'];
    ?>

    <div class="mb-3">
        <button class="btn btn-sm" id="closebtn"><i class="glyphicon glyphicon-off"></i> Close</button>
        <button class="btn btn-sm" id="printbtn"><i class="glyphicon glyphicon-print"></i> Print</button>
    </div>

    <h2 id="lablrpt">Sale & Stock Report</h2>

    <div class="table-responsive">
        <table class="report-table">
            <tr>
                <th>Item Name</th>
                <th>Current Stock</th>
                <th>Average Rate</th>
                <th>Stock Value</th>
            </tr>

            <?php
            $Tstockvalue = 0;
            $qry = "SELECT stockledger.itemid, itemname
                    FROM stockledger
                    JOIN itemreg ON stockledger.itemid = itemreg.itemid
                    WHERE stockledger.dated<='$to'
                    GROUP BY stockledger.itemid, itemname
                    HAVING (SUM(stockin) - SUM(stockout)) > 0
                    ORDER BY stockledger.itemid";
            $run_qry = mysqli_query($connect, $qry);

            while($row = mysqli_fetch_array($run_qry)){       
                $itemid = $row['itemid'];
                $currstk = 0;
                $curravgrate = 0;
                $currstockvalue = 0;

                $qry2 = "SELECT trid, stockin, ratein, stockout, rateout, invoiceno, dated 
                         FROM stockledger  
                         WHERE itemid='$itemid' AND dated<='$to' 
                         ORDER BY dated, trid ASC";
                $run_qry2 = mysqli_query($connect, $qry2);

                while($row2 = mysqli_fetch_array($run_qry2)){       
                    $stkin = round($row2['stockin'],2);
                    $stkout = round($row2['stockout'],2);

                    $currstk = round(($currstk + $stkin - $stkout),2);
                    $currstockvalue += ($stkin * round($row2['ratein'],2));

                    if($currstockvalue>0 && $currstk>0){
                        $currstockvalue -= ($stkout * round($curravgrate,2));
                        $curravgrate = $currstockvalue / $currstk;
                    }

                    if($currstk==0){
                        $curravgrate=0;
                        $currstockvalue=0;
                    }
                }
            ?>

            <tr class="item-summary">
                <td><?php echo $row['itemname']; ?></td>
                <td><?php echo round($currstk,4); ?></td>
                <td><?php echo round($curravgrate,2); ?></td>
                <td><?php echo round($currstockvalue,2); ?></td>
            </tr>

            <?php
                $Tstockvalue += $currstockvalue;
            }
            ?>

            <tr style="font-weight:bold; background:#bdc3c7;">
                <td colspan="3" style="text-align:center;">Total Stock Value</td>
                <td><?php echo round($Tstockvalue,2); ?></td>
            </tr>
        </table>
    </div>
</div>

<script>
$(document).ready(function(){
    $('#printbtn').click(function(){
        window.print();
    });

    $('#closebtn').click(function(){
        window.close();
    });
});
</script>
</body>
</html>
